/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ImageOne {
    private JPanel menuPanel;
    private JPanel imagePanel;
    private JFrame menuFrame;
    private JFrame imageFrame;
    private JButton[] buttons = new JButton[16];
    private JLabel photo;
    private BufferedImage originalBuffer;
    private BufferedImage modifiedBuffer;
    private BufferedImage puzzleBuffer;
    private ImageIcon modifiedIcon;
    private int imageWidth;
    private int imageHeight;
    private Point puzzleBlank;
    private Point[][] orig = new Point[3][3];
    private Point[][] shuf = new Point[3][3];
    private MouseListener zoomer;
    private MouseListener puzzler;
    private boolean playing = false;
    private int playButton = 10;
    private int quitButton = 13;
    private JFileChooser fc = new JFileChooser(".");

    ImageOne() {
        this.initialize("");
    }

    ImageOne(String string) {
        this.initialize(string);
    }

    private void initialize(String string) {
        int n;
        int n2;
        this.menuFrame = new JFrame("Image Manipulation Menu");
        for (n2 = 0; n2 < this.buttons.length; ++n2) {
            this.buttons[n2] = new JButton();
            this.buttons[n2].setBackground(Color.yellow);
            this.buttons[n2].setFont(new Font("Dialog", 0, 24));
            this.buttons[n2].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImageOne.this.performAction(actionEvent.getActionCommand());
                }
            });
        }
        n2 = 0;
        this.buttons[n2].setBackground(Color.blue);
        this.buttons[n2].setText("Load");
        this.buttons[++n2].setBackground(Color.blue);
        this.buttons[n2].setText("Save");
        int n3 = ++n2;
        this.buttons[n3].setText("Flip Vertical");
        int n4 = ++n2;
        this.buttons[n4].setText("Flip Horizontal");
        int n5 = ++n2;
        this.buttons[n5].setText("Negative");
        int n6 = ++n2;
        this.buttons[n6].setText("24 Colors");
        int n7 = ++n2;
        this.buttons[n7].setText("Lighten");
        int n8 = ++n2;
        this.buttons[n8].setText("Darken");
        int n9 = ++n2;
        this.buttons[n9].setText("Rotate 90");
        int n10 = ++n2;
        this.buttons[n10].setText("Blur");
        int n11 = ++n2;
        this.buttons[n11].setText("Remove Red");
        int n12 = ++n2;
        this.buttons[n12].setText("Greyscale");
        int n13 = ++n2;
        this.buttons[n13].setText("Add Noise");
        int n14 = ++n2;
        this.playButton = n14;
        this.buttons[this.playButton].setText("Eight Puzzle");
        this.buttons[++n2].setBackground(Color.green);
        this.buttons[n2].setText("Restore");
        int n15 = ++n2;
        ++n2;
        this.quitButton = n15;
        this.buttons[this.quitButton].setBackground(Color.red);
        this.buttons[this.quitButton].setText("Quit");
        this.menuPanel = new JPanel();
        this.menuPanel.setBackground(Color.black);
        this.menuPanel.setLayout(new GridLayout(this.buttons.length / 2, 2));
        for (n = 0; n < this.buttons.length; ++n) {
            this.menuPanel.add(this.buttons[n]);
        }
        this.menuFrame.getContentPane().add((Component)this.menuPanel, "Center");
        this.menuFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.menuFrame.pack();
        this.imageFrame = new JFrame("Image");
        n = 2;
        MediaTracker mediaTracker = null;
        Image image = null;
        while (n >= 0) {
            mediaTracker = new MediaTracker(this.imageFrame);
            image = Toolkit.getDefaultToolkit().getImage(string);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException);
                System.exit(1);
            }
            if (image.getWidth(null) == -1 && n > 0) {
                JOptionPane.showMessageDialog(null, "Image file required.", "Error", 0);
                string = this.getFileName();
                --n;
                continue;
            }
            n = -1;
        }
        if (n < 0 && image.getWidth(null) == -1) {
            JOptionPane.showMessageDialog(null, "Image file required.\nExiting.", "Error", 0);
            System.exit(1);
        }
        this.originalBuffer = ImageOne.toBufferedImage(image);
        this.modifiedBuffer = ImageOne.toBufferedImage(image);
        this.imageWidth = this.originalBuffer.getWidth(null);
        this.imageHeight = this.originalBuffer.getHeight(null);
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo = new JLabel(this.modifiedIcon);
        this.photo.setIcon(this.modifiedIcon);
        this.zoomer = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ImageOne.this.zoom(mouseEvent.getPoint());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
        this.puzzler = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ImageOne.this.play(mouseEvent.getPoint());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
        this.photo.addMouseListener(this.zoomer);
        this.imagePanel = new JPanel();
        this.imagePanel.setBackground(Color.black);
        this.imagePanel.add(this.photo);
        this.imageFrame.getContentPane().add((Component)this.imagePanel, "Center");
        this.imageFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.imageFrame.pack();
        Point point = this.menuFrame.getLocation();
        this.imageFrame.setLocation(point.x + this.menuFrame.getSize().width + 25, point.y);
        this.menuFrame.setLocation(20, 20);
        this.menuFrame.setVisible(true);
        this.imageFrame.setLocation(point.x + this.menuFrame.getSize().width + 25, point.y + 25);
        this.imageFrame.setVisible(true);
    }

    private String getFileName() {
        int n = this.fc.showOpenDialog(this.menuFrame);
        String string = "";
        if (n == 0) {
            File file = this.fc.getSelectedFile();
            string = file.getAbsolutePath();
        }
        return string;
    }

    private void loadImage() {
        File file;
        String string;
        int n = this.fc.showOpenDialog(this.menuFrame);
        if (n == 0 && this.loadImage(string = (file = this.fc.getSelectedFile()).getAbsolutePath()) && this.playing) {
            this.stopPuzzle();
        }
    }

    private boolean loadImage(String string) {
        int[] nArray = new int[3];
        JFrame jFrame = new JFrame(string);
        MediaTracker mediaTracker = new MediaTracker(jFrame);
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
            System.exit(1);
        }
        if (image.getWidth(null) == -1) {
            JOptionPane.showMessageDialog(null, "Graphics file format unknown.", "Error", 0);
            return false;
        }
        this.originalBuffer = ImageOne.toBufferedImage(image);
        this.modifiedBuffer = ImageOne.toBufferedImage(image);
        this.imageWidth = this.modifiedBuffer.getWidth(null);
        this.imageHeight = this.modifiedBuffer.getHeight(null);
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
        Point point = this.menuFrame.getLocation();
        this.imageFrame.setLocation(this.menuFrame.getSize().width + 25, point.y + 25);
        return true;
    }

    public static void saveAsJPEG(RenderedImage renderedImage, String string) throws IOException {
        String string2 = string;
        if (!string2.endsWith(".jpg")) {
            string2 = new String(string + ".jpg");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        ImageIO.write(renderedImage, "jpg", fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public void performAction(String string) {
        if (string.equals("Remove Red")) {
            if (!this.playing) {
                this.removeRed();
            }
        } else if (string.equals("Flip Vertical")) {
            if (!this.playing) {
                this.flipV();
            }
        } else if (string.equals("Flip Horizontal")) {
            if (!this.playing) {
                this.flipH();
            }
        } else if (string.equals("24 Colors")) {
            if (!this.playing) {
                this.reduceColor();
            }
        } else if (string.equals("Negative")) {
            if (!this.playing) {
                this.negative();
            }
        } else if (string.equals("Darken")) {
            if (!this.playing) {
                this.darken(0.9);
            }
        } else if (string.equals("Lighten")) {
            if (!this.playing) {
                this.lighten(0.9);
            }
        } else if (string.equals("Rotate 90")) {
            if (!this.playing) {
                this.rotateCW();
            }
        } else if (string.equals("Blur")) {
            if (!this.playing) {
                this.blur();
            }
        } else if (string.equals("Greyscale")) {
            if (!this.playing) {
                this.grey();
            }
        } else if (string.equals("Eight Puzzle")) {
            this.puzzle();
        } else if (string.equals("Stop Puzzle")) {
            this.stopPuzzle();
        } else if (string.equals("Add Noise")) {
            if (!this.playing) {
                this.noise(20);
            }
        } else if (string.equals("Restore")) {
            if (!this.playing) {
                this.restoreImage(this.originalBuffer);
            }
        } else if (string.equals("Quit")) {
            System.exit(0);
        } else if (string.equals("Load")) {
            if (!this.playing) {
                this.loadImage();
            }
        } else if (string.equals("Save")) {
            int n;
            if (!this.playing && (n = this.fc.showSaveDialog(this.menuFrame)) == 0) {
                if (this.playing) {
                    this.stopPuzzle();
                }
                File file = this.fc.getSelectedFile();
                String string2 = file.getAbsolutePath();
                if (!file.exists() || JOptionPane.showConfirmDialog(null, file.getName() + " already exists.\n" + "Are you sure you want to overwrite it?  ") == 0) {
                    try {
                        ImageOne.saveAsJPEG(this.modifiedBuffer, string2);
                        JOptionPane.showMessageDialog(null, "File saved", "Success", -1);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        } else {
            System.out.println("Button has no assigned action.");
        }
        this.imageFrame.pack();
    }

    public void restoreImage(BufferedImage bufferedImage) {
        int n;
        this.imageWidth = bufferedImage.getWidth(null);
        this.imageHeight = bufferedImage.getHeight(null);
        this.modifiedBuffer = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (n = 0; n < this.imageHeight; ++n) {
                writableRaster.getPixel(i, n, nArray);
                writableRaster2.setPixel(i, n, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        MouseListener[] mouseListenerArray = this.photo.getMouseListeners();
        for (n = 0; n < mouseListenerArray.length; ++n) {
            this.photo.removeMouseListener(mouseListenerArray[n]);
        }
        this.photo.addMouseListener(this.zoomer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void removeRed() {
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                nArray[0] = 0;
                writableRaster.setPixel(i, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void grey() {
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                int n;
                writableRaster.getPixel(i, j, nArray);
                nArray[0] = n = (nArray[0] + nArray[1] + nArray[2]) / 3;
                nArray[1] = n;
                nArray[2] = n;
                writableRaster.setPixel(i, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void blur() {
        BufferedImage bufferedImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n = 0;
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                int n2;
                for (n2 = i - 1; n2 <= i + 1; ++n2) {
                    for (int k = j - 1; k <= j + 1; ++k) {
                        try {
                            writableRaster.getPixel(n2, k, nArray);
                            ++n;
                            for (int i2 = 0; i2 < 3; ++i2) {
                                int n3 = i2;
                                nArray2[n3] = nArray2[n3] + nArray[i2];
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                n2 = 0;
                while (n2 < 3) {
                    int n4 = n2++;
                    nArray2[n4] = nArray2[n4] / n;
                }
                n = 0;
                writableRaster2.setPixel(i, j, nArray2);
                for (n2 = 0; n2 < 3; ++n2) {
                    nArray2[n2] = 0;
                }
            }
        }
        this.modifiedBuffer = bufferedImage;
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void darken(double d) {
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                for (int k = 0; k < 3; ++k) {
                    nArray[k] = (int)((double)nArray[k] * d);
                    if (nArray[k] >= 0) continue;
                    nArray[k] = 0;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void lighten(double d) {
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                for (int k = 0; k < 3; ++k) {
                    nArray[k] = 255 - (int)((double)(255 - nArray[k]) * d);
                    if (nArray[k] >= 0) continue;
                    nArray[k] = 0;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void noise(int n) {
        Random random = new Random();
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                for (int k = 0; k < 3; ++k) {
                    int n2 = random.nextInt(n * 2 + 1) - n;
                    int n3 = k;
                    nArray[n3] = nArray[n3] + n2;
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                        continue;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void rotateCW() {
        BufferedImage bufferedImage = new BufferedImage(this.imageHeight, this.imageWidth, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster2.getPixel(i, j, nArray);
                writableRaster.setPixel(this.imageHeight - 1 - j, i, nArray);
            }
        }
        this.modifiedBuffer = bufferedImage;
        this.imageWidth = this.modifiedBuffer.getWidth(null);
        this.imageHeight = this.modifiedBuffer.getHeight(null);
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        Point point = this.menuFrame.getLocation();
        this.imageFrame.setLocation(point.x + this.menuFrame.getSize().width + 25, point.y + 25);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void zoom(Point point) {
        if (point.x < this.imageWidth / 4) {
            point.x = this.imageWidth / 4;
        } else if (point.x > 3 * this.imageWidth / 4) {
            point.x = 3 * this.imageWidth / 4;
        }
        if (point.y < this.imageHeight / 4) {
            point.y = this.imageHeight / 4;
        } else if (point.y > 3 * this.imageHeight / 4) {
            point.y = 3 * this.imageHeight / 4;
        }
        BufferedImage bufferedImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n3 = 0;
        n = point.x - this.imageWidth / 4;
        while (n < point.x + this.imageWidth / 4) {
            n4 = 0;
            n2 = point.y - this.imageHeight / 4;
            while (n2 < point.y + this.imageHeight / 4) {
                writableRaster2.getPixel(n, n2, nArray);
                writableRaster.setPixel(n3, n4, nArray);
                writableRaster.setPixel(n3 + 1, n4, nArray);
                writableRaster.setPixel(n3, n4 + 1, nArray);
                writableRaster.setPixel(n3 + 1, n4 + 1, nArray);
                ++n2;
                n4 += 2;
            }
            ++n;
            n3 += 2;
        }
        this.modifiedBuffer = bufferedImage;
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void play(Point point) {
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        int[] nArray2 = new int[]{0, 0, 0};
        int n = 0;
        int n2 = 0;
        n = point.x < this.imageWidth / 3 ? 0 : (point.x < 2 * this.imageWidth / 3 ? 1 : 2);
        n2 = point.y < this.imageHeight / 3 ? 0 : (point.y < 2 * this.imageHeight / 3 ? 1 : 2);
        int n3 = this.puzzleBlank.x;
        int n4 = this.puzzleBlank.y;
        boolean bl = false;
        bl = n == n3 ? n2 == n4 - 1 || n2 == n4 + 1 : (n2 == n4 ? n == n3 - 1 || n == n3 + 1 : false);
        if (bl) {
            int n5;
            int n6;
            Point point2 = new Point(this.imageWidth / 3 * n, this.imageHeight / 3 * n2);
            Point point3 = new Point(this.imageWidth / 3 * this.puzzleBlank.x, this.imageHeight / 3 * this.puzzleBlank.y);
            Point point4 = this.shuf[n][n2];
            this.shuf[n][n2] = this.shuf[n3][n4];
            this.shuf[n3][n4] = point4;
            for (n6 = 0; n6 < this.imageWidth / 3; ++n6) {
                for (n5 = 0; n5 < this.imageHeight / 3; ++n5) {
                    writableRaster.getPixel(point2.x + n6, point2.y + n5, nArray);
                    writableRaster.setPixel(point2.x + n6, point2.y + n5, nArray2);
                    writableRaster.setPixel(point3.x + n6, point3.y + n5, nArray);
                }
            }
            this.modifiedIcon = new ImageIcon();
            this.modifiedIcon.setImage(this.modifiedBuffer);
            this.photo.setIcon(this.modifiedIcon);
            this.puzzleBlank = new Point(n, n2);
            n6 = 0;
            for (n5 = 0; n5 < 3; ++n5) {
                for (int i = 0; i < 3; ++i) {
                    if (!this.orig[n5][i].equals(this.shuf[n5][i])) continue;
                    ++n6;
                }
            }
            if (n6 == 9) {
                JOptionPane.showMessageDialog(null, "You solved the puzzle!", "Congratulations", -1);
                this.stopPuzzle();
            }
        }
    }

    private void stopPuzzle() {
        this.buttons[this.playButton].setText("Eight Puzzle");
        this.enableButtons();
        this.restoreImage(this.puzzleBuffer);
        Point point = this.menuFrame.getLocation();
        this.imageFrame.setLocation(this.menuFrame.getSize().width + 25, point.y + 25);
    }

    private BufferedImage copyBufferedImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                writableRaster2.setPixel(i, j, nArray);
            }
        }
        return bufferedImage2;
    }

    public void puzzle() {
        int n;
        int n2;
        int n3;
        this.puzzleBuffer = this.copyBufferedImage(this.modifiedBuffer);
        int n4 = this.imageWidth - this.imageWidth % 3;
        int n5 = this.imageHeight - this.imageHeight % 3;
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n6 = 0;
        int n7 = 0;
        while (n6 < n4) {
            n3 = 0;
            n2 = 0;
            while (n3 < n5) {
                this.orig[n7][n2] = new Point(n6, n3);
                n3 += n5 / 3;
                ++n2;
            }
            n6 += n4 / 3;
            ++n7;
        }
        int[] nArray = new int[]{255, 255, 0};
        for (n7 = 0; n7 < 3; ++n7) {
            for (n3 = 0; n3 < n5; ++n3) {
                writableRaster.setPixel(n7 * n4 / 3, n3, nArray);
                writableRaster.setPixel((n7 + 1) * n4 / 3 - 1, n3, nArray);
            }
        }
        for (n7 = 0; n7 < 3; ++n7) {
            for (n3 = 0; n3 < n4; ++n3) {
                writableRaster.setPixel(n3, n7 * n5 / 3, nArray);
                writableRaster.setPixel(n3, (n7 + 1) * n5 / 3 - 1, nArray);
            }
        }
        Point[] pointArray = new Point[9];
        for (n3 = 0; n3 < 9; ++n3) {
            pointArray[n3] = this.orig[n3 / 3][n3 % 3];
        }
        Collections.shuffle(Arrays.asList(pointArray));
        for (n3 = 0; n3 < 9; ++n3) {
            this.shuf[n3 / 3][n3 % 3] = pointArray[n3];
        }
        int[] nArray2 = new int[3];
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                if (this.shuf[n2][n].equals(this.orig[2][2])) {
                    this.puzzleBlank = new Point(n2, n);
                    continue;
                }
                for (int i = 0; i < n4 / 3; ++i) {
                    for (int j = 0; j < n5 / 3; ++j) {
                        writableRaster.getPixel(this.shuf[n2][n].x + i, this.shuf[n2][n].y + j, nArray2);
                        writableRaster2.setPixel(this.orig[n2][n].x + i, this.orig[n2][n].y + j, nArray2);
                    }
                }
            }
        }
        this.modifiedBuffer = bufferedImage;
        this.imageWidth = this.modifiedBuffer.getWidth(null);
        this.imageHeight = this.modifiedBuffer.getHeight(null);
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
        this.disableButtons();
        this.buttons[this.playButton].setText("Stop Puzzle");
        MouseListener[] mouseListenerArray = this.photo.getMouseListeners();
        for (n = 0; n < mouseListenerArray.length; ++n) {
            this.photo.removeMouseListener(mouseListenerArray[n]);
        }
        Point point = this.menuFrame.getLocation();
        this.imageFrame.setLocation(this.menuFrame.getSize().width + 25, point.y + 25);
        this.photo.addMouseListener(this.puzzler);
    }

    private void enableButtons() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (i == this.quitButton) continue;
            this.buttons[i].setForeground(Color.BLACK);
        }
        this.playing = false;
    }

    private void disableButtons() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (i == this.playButton || i == this.quitButton) continue;
            this.buttons[i].setForeground(Color.GRAY);
        }
        this.playing = true;
    }

    public void reduceColor() {
        int n = 32;
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                nArray[0] = nArray[0] / n * n + n / 2;
                nArray[1] = nArray[1] / n * n + n / 2;
                nArray[2] = nArray[2] / n * n + n / 2;
                writableRaster.setPixel(i, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void negative() {
        int n = 32;
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                nArray[0] = 255 - nArray[0];
                nArray[1] = 255 - nArray[1];
                nArray[2] = 255 - nArray[2];
                writableRaster.setPixel(i, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void flipH() {
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        for (int i = 0; i < this.imageWidth / 2; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                writableRaster.getPixel(i, j, nArray);
                writableRaster.getPixel(this.imageWidth - i - 1, j, nArray2);
                writableRaster.setPixel(i, j, nArray2);
                writableRaster.setPixel(this.imageWidth - i - 1, j, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public void flipV() {
        WritableRaster writableRaster = this.modifiedBuffer.getRaster();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight / 2; ++j) {
                writableRaster.getPixel(i, j, nArray);
                writableRaster.getPixel(i, this.imageHeight - j - 1, nArray2);
                writableRaster.setPixel(i, j, nArray2);
                writableRaster.setPixel(i, this.imageHeight - j - 1, nArray);
            }
        }
        this.modifiedIcon = new ImageIcon();
        this.modifiedIcon.setImage(this.modifiedBuffer);
        this.photo.setIcon(this.modifiedIcon);
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), 1);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            File file = new File(stringArray[0]);
            if (file.exists()) {
                ImageOne imageOne = new ImageOne(stringArray[0]);
            } else {
                System.err.println(stringArray[0] + ": File not found.");
                System.exit(0);
            }
        } else {
            ImageOne imageOne = new ImageOne();
        }
    }
}

